-- 2D clouds
-- skydomes


--ac.setAsyncTextureLoading(true)

function PURE__2DCLOUDS_fogV2_table()
    return {
        height = 8,
        exponent = 2,
        Yoff = -0.0,
        level = 1.0,
        level_bottom = 1.5,
        saturation = 1.0,
        addFog = 0.0,
    }
end

local _l_skydome_brightness = 1.0
function PURE__2DCLOUDS_get_brightness()
    return _l_skydome_brightness
end

local _l_skydome_contrast = 1.0
function PURE__2DCLOUDS_get_contrast()
    return _l_skydome_contrast
end

local _l_skydome_NLP_density = 0.0
function PURE__2DCLOUDS_get_NLP_density()
    return _l_skydome_NLP_density
end

require 'pure/world/clouds/2d/class_texture'
require 'pure/world/clouds/2d/class_weather'
require 'pure/world/clouds/2d/class_set'


local _l_COVER_SET = PURE_CLASS_2dClouds_set()
local _l_EXTERNAL_SETS = {}
function PURE__2DCLOUDS_importSet(name)
    
end

function PURE__2DCLOUDS_setKey(key)
    _l_COVER_SET:setKey(key)
end

function PURE__2DCLOUDS_add_texture(name, file)
    return _l_COVER_SET:addTexture(name, file)
end

function PURE__2DCLOUDS_set_weather_texture(weather_name, texture_name, sunangle)
    return _l_COVER_SET:setWeatherTexture(weather_name, texture_name, sunangle)
end

function PURE__2DCLOUDS_copy_section_to_weather(weather_name, section)
    return _l_COVER_SET:cloneSection(weather_name, section)
end

function PURE__2DCLOUDS_get_weather(weather_name)
    return _l_COVER_SET:getWeather(weather_name)
end

function PURE__2DCLOUDS_duplicate_weather(weather_name_from, weather_name_to)
    return _l_COVER_SET:cloneWeather(weather_name_from, weather_name_to)
end

local _l_weather_3d_cloud_shadow_amounts = {}
function PURE__2DCLOUDS_set_weather_3dcloud_shadows(weather, amount)
    local id = PURE__weather_ids[weather]
    if id then
        _l_weather_3d_cloud_shadow_amounts[id] = amount
    end
end
function PURE__2DCLOUDS_get_weather_cloud_shadows_list() return _l_weather_3d_cloud_shadow_amounts end

local _l_sky_adaption = hsv(0,1,1)
function PURE__2DCLOUDS_set_sky_adaption(h, s, v)
    _l_sky_adaption.h = h
    _l_sky_adaption.s = s
    _l_sky_adaption.v = v
end
--[[
function PURE__2DCLOUDS_get_sky_adaption()
    return _l_COVER_SET.sky_adaption
end
]]
function PURE__2DCLOUDS_get_directional_ambient_add()
    return _l_COVER_SET.directional_ambient_add
end
function PURE__2DCLOUDS_get_ambient_mod()
    return _l_COVER_SET.ambient_mod
end
function PURE__2DCLOUDS_get_current_brightness()
    return _l_COVER_SET.current_brightness
end
function PURE__2DCLOUDS_get_3dcloudShadows_SunShutterOpacity()
    return _l_COVER_SET.sun_shutter_opacity
end
function PURE__2DCLOUDS_get_3dcloudShadows_SunShutterSize()
    return _l_COVER_SET.sun_shutter_size
end
function PURE__2DCLOUDS_get_cloud_coverage()
    return _l_COVER_SET.cloud_coverage
end
function PURE__2DCLOUDS_allowRotationOscillation(b)
    _l_COVER_SET.allowRotationOscillation = b
end
function PURE__2DCLOUDS_set_default_Sunlight_LUT(lut)
    _l_COVER_SET:setDefaultSunLightLUT(lut)
end
function PURE__2DCLOUDS_set_default_Moonlight_LUT(lut)
    _l_COVER_SET:setDefaultMoonLightLUT(lut)
end
function PURE__2DCLOUDS_set_default_sky_adaption(h,s,v)
    _l_COVER_SET:setDefaultSkyAdaption(h,s,v)
end
function PURE__2DCLOUDS_setTextureLoadingPosition(x)
    _l_COVER_SET:setTextureLoadingPosition(x)
end
function PURE__2DCLOUDS_getFogV2Params()
    return _l_COVER_SET.fog_paramsV2
end

function PURE__2DCLOUDS_encryptTextures(key, tex_list)
    if key and key~="" then
        _l_COVER_SET:encryptTextures(key, tex_list)
    else
        ac.debug("Encryption", "no key given")
    end
end

function PURE__2DCLOUDS_doInstantFade()
    _l_COVER_SET:doInstantFade()
end

local _l_skydome_sets_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\Pure\\Skydome_sets\\"
local _l_skydome_set = __PURE__get_config("clouds2D.set")


function clouds__2D_checkSets()
    local sets_list = {}
    io.scanDir(_l_skydome_sets_path, "*", function(name, attrib)
        if attrib.isDirectory then
            if file_exists(_l_skydome_sets_path..name.."\\skydome_script.lua") then
                table.insert(sets_list, name)
            end
        end
    end)

    if #sets_list>0 then
        local found = false
        local default = false
        local default16 = false
        for i=1, #sets_list do
            if sets_list[i] == _l_skydome_set then
                found = true
                break
            end
            if sets_list[i] == "default_16k" then
                default16 = true
            end
            if sets_list[i] == "default" then
                default = true
            end
        end
        if not found and (default or default16) then
            if _l_skydome_set == "default" and not default then
                if default16 then
                    _l_skydome_set = "default_16k"
                else
                    PURE_ERR("Skydome Error", "Set \"".._l_skydome_set.."\" was not found! Default set could not be loaded!")
                end
            else
                PURE_ERR("Skydome Error", "Set \"".._l_skydome_set.."\" was not found! Default set was loaded instead of it!")
                if default16 then
                    _l_skydome_set = "default_16k"
                else
                    _l_skydome_set = "default"
                end
            end
            __PURE__reset_config("clouds2D.set", _l_skydome_set)
        end
    else
        PURE_ERR("Skydome Error", "No skydome could be found in ".._l_skydome_sets_path)
        _l_skydome_set = nil
    end
end
clouds__2D_checkSets()

local _l_current_skydome_set_path = _l_skydome_sets_path.._l_skydome_set.."\\"
function PURE__2DCLOUDS_get_skydome_set_path()
    return _l_current_skydome_set_path
end

__PURE_use_3d_cloud_shadows = __PURE__get_config("clouds2D.advanced_shadows")

local _l_cubemaps_fog_process = 1.0
local _l_shader_full = {
    blendMode = render.BlendMode.AlphaBlend,
    depthMode = render.DepthMode.ReadOnly,
    depth = 1e4,
    textures = {

        -- Mountain Fix Stuff
        txSilhouette = ui.ExtraCanvas(vec2(0,0)),
    },
    values = {
        gMix = 1.0,
        gLevel = 1.0,
        gLevelBottom = 1.0,
        gHeight = 4.0,
        gExponent = 2.0,
        gYoff = 0.025,
        gFogAdd = 0.0,
        gDither = 1.0,
        gExtra = false,
        gPollutionTint = rgb(1,1,1),

        -- Mountain Fix Stuff
        gMountainFix = false,
        gStrength = 0.3,
    },
    extensions = {'sky'},
    shader = __pure__path.."\\pure\\world\\clouds\\2d\\bottom.fx",
    async = false,
    --directValuesExchange  = false,
}

local _l_color_multiplier = rgb(1,1,1)
local _l_color_multiplier_used = false
function PURE__SKYDOMES__set_color_multiplier__rgb(r, g, b)
    _l_color_multiplier:set(r, g, b)
    _l_color_multiplier_used = (r~=1 and g~=1 and b~=1)
end
local _l_rgb_tmp = rgb(0,0,1)
function PURE__SKYDOMES__set_color_multiplier__hsv(h, s, v)
    HSVToRGB_To(_l_rgb_tmp, h, s, v)
    PURE__SKYDOMES__set_color_multiplier__rgb(_l_rgb_tmp.r, _l_rgb_tmp.g, _l_rgb_tmp.b)
end
function PURE__SKYDOMES__get_color_multiplier()
    return _l_color_multiplier
end

local _l_shader_color = {
    blendMode = render.BlendMode.BlendMultiply,
    depthMode = render.DepthMode.ReadOnly,
    depth = 1e4,
    values = {
        gColor = rgb(1,1,1),
    },
    --extensions = {'sky'},
    shader = [[
        float4 main(PS_IN pin){
            return float4(gColor,1);
        }
    ]],
    async = true,
}

function PURE__2DCLOUDS_getFogV2ShaderValues()
    return _l_shader_full.values
end

local function render__skydomes_bottom__MainEffect(passID, frameIndex, uniqueKey)

    local fog_hori_sky_multi = FOG__get_horizon_sky_mulit()
    local sky = math.saturateN(fog_hori_sky_multi.sky)
    local sky_2 = sky * sky
    local sky_3 = sky_2 * sky

    local humid = math.saturateN((Pure_get_Humidity()-0.5) * 2)
    local sky_level = __PURE__get_config("sky.level") * from_twilight_compensate(0)

    --_l_COVER_SET:
    _l_shader_full.values.gHeight   = math.lerp(_l_COVER_SET.fog_paramsV2.height,   1.00,   math.max(math.saturateN(3*sky_3), humid))
    
    local level = _l_COVER_SET.fog_paramsV2.level * __PURE__sun_lamps_difference_convert41_div --* _d(1/_l_skydome_contrast^0.5)
    _l_shader_full.values.gLevel    = math.lerp(level * sky_level,    1.00,   math.max(math.saturate(2*sky_2), math.saturateN(humid*1.5)))

    _l_shader_full.values.gExponent = math.lerp(_l_COVER_SET.fog_paramsV2.exponent, 2.00,   sky_2)
    _l_shader_full.values.gExponent = math.lerp(_l_shader_full.values.gExponent,    1.00,   humid)

    _l_shader_full.values.gFogAdd   = math.max(_l_COVER_SET.fog_paramsV2.addFog, math.saturateN(1.05*sky_3))

    _l_shader_full.values.gLevelBottom = math.lerp(_l_COVER_SET.fog_paramsV2.level_bottom * sky_level, 1.0, math.max(math.saturateN(humid*1.5), math.saturateN(3*_l_shader_full.values.gFogAdd)))

    _l_shader_full.values.gYoff     = 0--_l_COVER_SET.yOff*0.015
                                    + _l_COVER_SET.fog_paramsV2.Yoff
                                    + 0.025 * math.max(0, PURE__getTrackAdjustment_HORIZON_OFFSET())^0.825
                               
    _l_shader_full.values.gPollutionTint:set(CurrentConditions.pollution_tint)
    _l_shader_full.values.gPollutionTint.r = math.max(0.01, _l_shader_full.values.gPollutionTint.r)
    _l_shader_full.values.gPollutionTint.g = math.max(0.01, _l_shader_full.values.gPollutionTint.g)
    _l_shader_full.values.gPollutionTint.b = math.max(0.01, _l_shader_full.values.gPollutionTint.b)




    -- Mountain Fix
    if PURE__mountains_shader_get_mountain_silhouette then
        local texSilhouette = PURE__mountains_shader_get_mountain_silhouette()
    
        if texSilhouette.active and texSilhouette.textures[frameIndex]~=nil then
            _l_shader_full.values.gMountainFix = true
            _l_shader_full.values.gStrength = (0.5 + math.saturate(CurrentConditions.clouds * 2) + (3.5 * math.saturate(25 * Pure_get_Fog())))
            _l_shader_full.textures.txSilhouette = texSilhouette.textures[frameIndex]
         else
            _l_shader_full.values.gMountainFix = false
        end
    else
        _l_shader_full.values.gMountainFix = false
    end





    if passID < 2 then -- Main pass
        _l_shader_full.values.gDither = math.saturateN((_l_shader_full.values.gFogAdd - 0.5) * 4)
        _l_shader_full.values.gMix = 1.0
        _l_shader_full.values.gExtra = true
    else -- Mirrors + Cubemaps
        _l_shader_full.values.gExtra = false
        if passID < 4 then
            _l_shader_full.values.gMix = 1.0
        else
            _l_shader_full.values.gMix = math.saturate(_l_cubemaps_fog_process)
        end
    end

    --ac.debug(frameIndex, _l_shader_full.values.gHeight)
                                    
    render.fullscreenPass(_l_shader_full)
    --if _l_color_multiplier_used then
    --    _l_shader_color.values.gColor:set(_l_color_multiplier)
    --    render.fullscreenPass(_l_shader_color)
    --end


--[[
render.fullscreenPass(_l_shader_full)
]]
end



local subscribed_sky_effect ---@type fun()

function SKYDOMES__init()
        
    if _l_skydome_set then

        --ac.setAsyncTextureLoading(true)

        if file_exists(_l_current_skydome_set_path.."skydome_script_lcs.lua") then
            dofile(_l_current_skydome_set_path.."skydome_script_lcs.lua")
        else
            dofile(_l_current_skydome_set_path.."skydome_script.lua")
        end

        
        
        -- call the custom set's init
        if init_skydome_LUTs~=nil   then init_skydome_LUTs()    end
        if init_skydome_set~=nil    then init_skydome_set()     end
        --if __PURE__get_config("clouds2D.preload") then
        --    _l_COVER_SET:preloadTextures()
        --end
        _l_COVER_SET:checkTexturesCompleteness()

        function clouds__2D__setClouds(currW, nextW, transition, fade_position)
            _l_COVER_SET:setCondition(currW, nextW, transition, fade_position)
        end

        
        local _l_last_main_menu = __AC_SIM.isInMainMenu
        function clouds_2d_update(dt)

            _l_skydome_brightness   = __PURE__get_config("clouds2D.brightness") * __PURE__sun_lamps_difference
            _l_skydome_contrast     = __PURE__get_config("clouds2D.contrast")
            _l_skydome_NLP_density  = __PURE__get_config("nlp.density")
            _l_cubemaps_fog_process = __PURE__get_config("fog.cubemaps")

            if not subscribed_sky_effect then
                subscribed_sky_effect = RenderSkySubscribe(7, render__skydomes_bottom__MainEffect) -- main + mirrors + cubemaps
            end
            
            __PURE__Clouds_shadow__SkyCover = 1-ac.getCloudCoversShadow()

            if not __PURE_use_3d_cloud_shadows then
                __PURE__Clouds_shadow__2d_global_shadow = 1-__PURE__Clouds_shadow__SkyCover
            else
                __PURE__Clouds_shadow__2d_global_shadow = 1
            end

            if __AC_SIM.isInMainMenu ~= _l_last_main_menu then
                PURE__2DCLOUDS_doInstantFade()
                _l_last_main_menu = __AC_SIM.isInMainMenu
            end

            _l_COVER_SET:update(dt)
        end

        function clouds_2d_async_update(dt)

        end
        
        function clouds_2d_handle_pure_reset()
            -- reset is too fast
            -- _l_COVER_SET:unloadAllTextures()
        end
    else
        function clouds__2D__setClouds(currW, nextW, transition) end
        function clouds_2d_update(dt) end
        function clouds_2d_async_update(dt) end
        function clouds_2d_handle_pure_reset() end
    end
end
--SKYDOMES__init()



